<?php
/**
 * Background Pattern Style - Scallops.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Scallops
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Scallops extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Scallops', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M0,21.68a50,50,0,0,0,39.77,28A40.1,40.1,0,0,1,0,85.05V95a40.1,40.1,0,0,1,39.77,35.37A50,50,0,0,0,0,158.32V180H5a40.09,40.09,0,0,1,35.37-39.76,50.08,50.08,0,0,0,28,39.76h43.36a50.08,50.08,0,0,0,28-39.76A40.09,40.09,0,0,1,175.05,180H180V158.32a50,50,0,0,0-39.77-28A40.1,40.1,0,0,1,180,95v-9.9a40.1,40.1,0,0,1-39.77-35.37,50,50,0,0,0,39.77-28V0h-4.95a40.09,40.09,0,0,1-35.37,39.76A50.08,50.08,0,0,0,111.65,0H68.35a50.08,50.08,0,0,0-28,39.76A40.09,40.09,0,0,1,5,0H0ZM90,175.05a40.1,40.1,0,0,1-39.77-35.37,50,50,0,0,0,39.77-28,50,50,0,0,0,39.77,28A40.1,40.1,0,0,1,90,175.05ZM158.32,90a50.08,50.08,0,0,0-28,39.76,40,40,0,0,1,0-79.52A50.08,50.08,0,0,0,158.32,90ZM90,5a40.1,40.1,0,0,1,39.77,35.37A50,50,0,0,0,90,68.32a50,50,0,0,0-39.77-28A40.1,40.1,0,0,1,90,5ZM49.68,50.24a40,40,0,0,1,0,79.52A50.08,50.08,0,0,0,21.68,90,50.08,50.08,0,0,0,49.68,50.24Z"/>',
				'default-inverted' => '<path d="M0,158.32V95a40.1,40.1,0,0,1,39.77,35.37A50,50,0,0,0,0,158.32Zm40.32-18.08A40.09,40.09,0,0,0,5,180H68.32A50.08,50.08,0,0,1,40.32,140.24Zm-.55-90.56A50,50,0,0,1,0,21.68V85.05A40.1,40.1,0,0,0,39.77,49.68Zm50.23,62a50,50,0,0,1-39.77,28,40,40,0,0,0,79.54,0A50,50,0,0,1,90,111.68Zm0-43.36a50,50,0,0,1,39.77-28,40,40,0,0,0-79.54,0A50,50,0,0,1,90,68.32ZM95,90a40.09,40.09,0,0,0,35.37,39.76,50.08,50.08,0,0,1,28-39.76,50.08,50.08,0,0,1-28-39.76A40.09,40.09,0,0,0,95,90ZM40.32,39.76A50.08,50.08,0,0,1,68.35,0H5A40.09,40.09,0,0,0,40.32,39.76ZM21.68,90a50.08,50.08,0,0,1,28,39.76,40,40,0,0,0,0-79.52A50.08,50.08,0,0,1,21.68,90Zm118-50.24A40.09,40.09,0,0,0,175.05,0h-63.4A50.08,50.08,0,0,1,139.68,39.76Zm.55,90.56a50,50,0,0,1,39.77,28V95A40.1,40.1,0,0,0,140.23,130.32Zm0-80.64A40.1,40.1,0,0,0,180,85.05V21.68A50,50,0,0,1,140.23,49.68Zm-.55,90.56a50.08,50.08,0,0,1-28,39.76h63.37A40.09,40.09,0,0,0,139.68,140.24Z"/>',
				'rotated'          => '<path d="M21.68,180a50,50,0,0,0,28-39.77A40.1,40.1,0,0,1,85.05,180H95a40.1,40.1,0,0,1,35.37-39.77,50,50,0,0,0,28,39.77H180v-4.95h0a40.09,40.09,0,0,1-39.76-35.37,50.08,50.08,0,0,0,39.76-28h0V68.32h0a50.08,50.08,0,0,0-39.76-28A40.09,40.09,0,0,1,180,5h0V0H158.32a50,50,0,0,0-28,39.77A40.1,40.1,0,0,1,95,0h-9.9A40.1,40.1,0,0,1,49.68,39.77,50,50,0,0,0,21.68,0H0V5H0A40.09,40.09,0,0,1,39.76,40.32,50.08,50.08,0,0,0,0,68.35v43.3a50.08,50.08,0,0,0,39.76,28A40.09,40.09,0,0,1,0,175.05H0V180ZM175.05,90a40.1,40.1,0,0,1-35.37,39.77,50,50,0,0,0-28-39.77,50,50,0,0,0,28-39.77A40.1,40.1,0,0,1,175.05,90ZM90,21.68a50.08,50.08,0,0,0,39.76,28,40,40,0,0,1-79.52,0A50.08,50.08,0,0,0,90,21.68ZM5,90A40.1,40.1,0,0,1,40.32,50.23,50,50,0,0,0,68.32,90a50,50,0,0,0-28,39.77A40.1,40.1,0,0,1,5,90Zm45.29,40.32a40,40,0,0,1,79.52,0,50.08,50.08,0,0,0-39.76,28A50.08,50.08,0,0,0,50.24,130.32Z"/>',
				'rotated-inverted' => '<path d="M158.32,180H95a40.1,40.1,0,0,1,35.37-39.77A50,50,0,0,0,158.32,180Zm-18.08-40.32A40.09,40.09,0,0,0,180,175.05h0V111.68h0A50.08,50.08,0,0,1,140.24,139.68Zm-90.56.55a50,50,0,0,1-28,39.77H85.05A40.1,40.1,0,0,0,49.68,140.23Zm62-50.23a50,50,0,0,1,28,39.77,40,40,0,0,0,0-79.54A50,50,0,0,1,111.68,90ZM68.32,90a50,50,0,0,1-28-39.77,40,40,0,0,0,0,79.54A50,50,0,0,1,68.32,90Zm21.68-5a40.09,40.09,0,0,0,39.76-35.37A50.08,50.08,0,0,1,90,21.68a50.08,50.08,0,0,1-39.76,28A40.09,40.09,0,0,0,90,85.05ZM39.76,139.68A50.08,50.08,0,0,1,0,111.65v63.4H0A40.09,40.09,0,0,0,39.76,139.68ZM90,158.32a50.08,50.08,0,0,1,39.76-28,40,40,0,0,0-79.52,0A50.08,50.08,0,0,1,90,158.32Zm-50.24-118A40.09,40.09,0,0,0,0,5H0v63.4A50.08,50.08,0,0,1,39.76,40.32Zm90.56-.55A50,50,0,0,1,158.32,0H95A40.1,40.1,0,0,0,130.32,39.77Zm-80.64,0A40.1,40.1,0,0,0,85.05,0H21.68A50,50,0,0,1,49.68,39.77Zm90.56.55a50.08,50.08,0,0,1,39.76,28h0V5h0A40.09,40.09,0,0,0,140.24,40.32Z"/>',
				'thumbnail'        => '<path d="M24.81,40h0A11.14,11.14,0,0,0,31,31.16,8.91,8.91,0,0,1,38.9,40h0A8.91,8.91,0,0,1,31,48.84,11.13,11.13,0,0,0,24.81,40Zm4,9A11.14,11.14,0,0,0,20,55.18,11.14,11.14,0,0,0,11.16,49a8.9,8.9,0,0,1,17.68,0ZM20,38.9A8.91,8.91,0,0,1,11.16,31,11.14,11.14,0,0,0,20,24.82,11.14,11.14,0,0,0,28.84,31,8.91,8.91,0,0,1,20,38.9ZM31.16,29a8.9,8.9,0,0,1,17.68,0A11.14,11.14,0,0,0,40,35.18,11.14,11.14,0,0,0,31.16,29ZM40,44.82A11.14,11.14,0,0,0,48.84,51a8.9,8.9,0,0,1-17.68,0A11.14,11.14,0,0,0,40,44.82ZM41.1,40h0A8.91,8.91,0,0,1,49,31.16,11.14,11.14,0,0,0,55.18,40h0A11.13,11.13,0,0,0,49,48.84,8.91,8.91,0,0,1,41.1,40Zm10.06-9A11.14,11.14,0,0,0,60,24.82,11.14,11.14,0,0,0,68.84,31a8.9,8.9,0,0,1-17.68,0ZM60,41.1A8.91,8.91,0,0,1,68.84,49,11.14,11.14,0,0,0,60,55.18,11.14,11.14,0,0,0,51.16,49,8.91,8.91,0,0,1,60,41.1ZM64.81,40h0A11.14,11.14,0,0,0,71,31.16,8.91,8.91,0,0,1,78.9,40h0A8.91,8.91,0,0,1,71,48.84,11.13,11.13,0,0,0,64.81,40ZM75.18,20A11.14,11.14,0,0,0,69,28.84a8.9,8.9,0,0,1,0-17.68A11.14,11.14,0,0,0,75.18,20ZM60,1.1A8.91,8.91,0,0,1,68.84,9,11.14,11.14,0,0,0,60,15.18,11.14,11.14,0,0,0,51.16,9,8.91,8.91,0,0,1,60,1.1ZM51,11.16a8.9,8.9,0,0,1,0,17.68A11.14,11.14,0,0,0,44.82,20,11.14,11.14,0,0,0,51,11.16ZM40,4.82A11.14,11.14,0,0,0,48.84,11a8.9,8.9,0,0,1-17.68,0A11.14,11.14,0,0,0,40,4.82ZM35.18,20A11.14,11.14,0,0,0,29,28.84a8.9,8.9,0,0,1,0-17.68A11.14,11.14,0,0,0,35.18,20ZM20,1.1A8.91,8.91,0,0,1,28.84,9,11.14,11.14,0,0,0,20,15.18,11.14,11.14,0,0,0,11.16,9,8.91,8.91,0,0,1,20,1.1ZM4.82,20A11.14,11.14,0,0,0,11,11.16a8.9,8.9,0,0,1,0,17.68A11.14,11.14,0,0,0,4.82,20ZM1.1,40h0A8.91,8.91,0,0,1,9,31.16,11.14,11.14,0,0,0,15.18,40h0A11.13,11.13,0,0,0,9,48.84,8.91,8.91,0,0,1,1.1,40ZM80,0H78.9A8.91,8.91,0,0,1,71,8.84,11.13,11.13,0,0,0,64.81,0H55.19A11.13,11.13,0,0,0,49,8.84,8.91,8.91,0,0,1,41.1,0H38.9A8.91,8.91,0,0,1,31,8.84,11.13,11.13,0,0,0,24.81,0H15.19A11.13,11.13,0,0,0,9,8.84,8.91,8.91,0,0,1,1.1,0H0V4.82A11.14,11.14,0,0,0,8.84,11,8.91,8.91,0,0,1,0,18.9v2.2A8.91,8.91,0,0,1,8.84,29,11.14,11.14,0,0,0,0,35.18v9.64A11.14,11.14,0,0,0,8.84,51,8.91,8.91,0,0,1,0,58.9V60H4.82A11.14,11.14,0,0,0,11,51.16,8.91,8.91,0,0,1,18.9,60h2.2A8.91,8.91,0,0,1,29,51.16,11.14,11.14,0,0,0,35.18,60h9.64A11.14,11.14,0,0,0,51,51.16,8.91,8.91,0,0,1,58.9,60h2.2A8.91,8.91,0,0,1,69,51.16,11.14,11.14,0,0,0,75.18,60H80V58.9A8.91,8.91,0,0,1,71.16,51,11.14,11.14,0,0,0,80,44.82V35.18A11.14,11.14,0,0,0,71.16,29,8.91,8.91,0,0,1,80,21.1V18.9A8.91,8.91,0,0,1,71.16,11,11.14,11.14,0,0,0,80,4.82Z"/>',
			),
			'width'      => '180px',
			'height'     => '180px',
		);
	}
}

return new ET_Builder_Pattern_Scallops();
